// PCanIsoTpExampleDlgMappings.cpp : implementation file
//
#include "stdafx.h"

// CPCanIsoTpExampleDlgMappings dialog

IMPLEMENT_DYNAMIC(CPCanIsoTpExampleDlgMappings, CDialogEx)
#ifdef _DEBUG
#define new DEBUG_NEW
#endif


CPCanIsoTpExampleDlgMappings::CPCanIsoTpExampleDlgMappings(TPCANTPHandle *p_pctpHandle, CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_PCANISOTPEXAMPLE_TAB_MAPPINGS, pParent)
{
	m_pctpHandle = p_pctpHandle; // Handle selected on combobox Channel
								 // Add the column headers to the CListCtrl
}

void CPCanIsoTpExampleDlgMappings::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON_ADD, buttonMappingAdd);
	DDX_Control(pDX, IDC_BUTTON_EXAMPLE, buttonMappingSample);
	DDX_Control(pDX, IDC_BUTTON_LOAD_MAPPINGS, buttonLoadMappings);
	DDX_Control(pDX, IDC_BUTTON_REMOVE, buttonMappingDel);
	DDX_Control(pDX, IDC_BUTTON_SAVE_MAPPINGS, buttonSaveMappings);
	DDX_Control(pDX, IDC_LIST_MAPPINGS, listViewMappings);
}


BEGIN_MESSAGE_MAP(CPCanIsoTpExampleDlgMappings, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_EXAMPLE, &CPCanIsoTpExampleDlgMappings::OnBnClickedButtonExample)
	ON_BN_CLICKED(IDC_BUTTON_REMOVE, &CPCanIsoTpExampleDlgMappings::OnBnClickedButtonRemove)
	ON_BN_CLICKED(IDC_BUTTON_ADD, &CPCanIsoTpExampleDlgMappings::OnBnClickedButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_SAVE_MAPPINGS, &CPCanIsoTpExampleDlgMappings::OnBnClickedButtonSaveMappings)
	ON_BN_CLICKED(IDC_BUTTON_LOAD_MAPPINGS, &CPCanIsoTpExampleDlgMappings::OnBnClickedButtonLoadMappings)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LIST_MAPPINGS, &CPCanIsoTpExampleDlgMappings::OnLvnItemchangedListMappings)
	ON_NOTIFY(LVN_INSERTITEM, IDC_LIST_MAPPINGS, &CPCanIsoTpExampleDlgMappings::OnLvnInsertitemListMappings)
END_MESSAGE_MAP()


/// <summary>
/// Sets the default "automatic" mappings.
/// Those mappings are set for tutorial/understanding purpose,
/// ISO-TP API handles internally CANTP messages with those
/// network information and do not require mappings to be defined.
/// </summary>
void CPCanIsoTpExampleDlgMappings::MappingsInit()
{
	// Initializes the internal list of mappings

	// 29 bits CAN ID, Normal Fixed and physical addressing
	m_mappings.push_back(new MappingStatus(0, 0, PCANTP_ID_CAN_29BIT,
		PCANTP_FORMAT_FIXED_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		PCANTP_ADDRESSING_PHYSICAL, 0, 0, 0));
	// 29 bits CAN ID, Normal Fixed and functional addressing
	m_mappings.push_back(new MappingStatus(0, 0, PCANTP_ID_CAN_29BIT,
		PCANTP_FORMAT_FIXED_NORMAL, PCANTP_MESSAGE_DIAGNOSTIC,
		PCANTP_ADDRESSING_FUNCTIONAL, 0, 0, 0));
	// 29 bits CAN ID, Mixed and physical addressing
	m_mappings.push_back(new MappingStatus(0, 0, PCANTP_ID_CAN_29BIT,
		PCANTP_FORMAT_MIXED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		PCANTP_ADDRESSING_PHYSICAL, 0, 0, 0));
	// 29 bits CAN ID, Mixed and functional addressing
	m_mappings.push_back(new MappingStatus(0, 0, PCANTP_ID_CAN_29BIT,
		PCANTP_FORMAT_MIXED, PCANTP_MESSAGE_REMOTE_DIAGNOSTIC,
		PCANTP_ADDRESSING_FUNCTIONAL, 0, 0, 0));
	m_mappings.push_back(new MappingStatus(0, 0, PCANTP_ID_CAN_29BIT,
		// 29 bits CAN ID, Enhanced and physical addressing (ISO 15765-3)
		PCANTP_FORMAT_ENHANCED, PCANTP_MESSAGE_DIAGNOSTIC,
		PCANTP_ADDRESSING_PHYSICAL, 0, 0, 0));

	// Adds the MappingStatus to the CListCtrl
	MappingsChanged();
}

/// <summary>
/// Function to be called when a change occured in the configured mappings.
/// The function updates all UI components according to the new settings.
/// </summary>
void CPCanIsoTpExampleDlgMappings::MappingsChanged()
{
	// index of the selected p_mapping in listViewMappings
	POSITION index_value = listViewMappings.GetFirstSelectedItemPosition();
	int index = reinterpret_cast<int>(index_value) - 1;
	UINT32 uniqueID = 0;

	if (index >= 0) // No item selected
	{
		int a = CPCanIsoTpUtils::HexStrToDec(listViewMappings.GetItemText(index, 0));
		// Store selected item in mappingListSel.
		uniqueID = CPCanIsoTpUtils::GetUniqueID({ CPCanIsoTpUtils::HexStrToDec(listViewMappings.GetItemText(index, 0)),
												CPCanIsoTpUtils::HexStrToDec(listViewMappings.GetItemText(index, 1)),
												(TPCANTPAddressingType)CPCanIsoTpUtils::GetCANDefValue(listViewMappings.GetItemText(index, 2)),
												(TPCANTPIdType)CPCanIsoTpUtils::GetCANDefValue(listViewMappings.GetItemText(index, 3)), 
												CPCanIsoTpUtils::HexStrToDec(listViewMappings.GetItemText(index, 4)),
												CPCanIsoTpUtils::HexStrToDec(listViewMappings.GetItemText(index, 5)),
												(TPCANTPMessageType)CPCanIsoTpUtils::GetCANDefValue(listViewMappings.GetItemText(index, 6)),
												(TPCANTPFormatType)CPCanIsoTpUtils::GetCANDefValue(listViewMappings.GetItemText(index, 7)), 
												CPCanIsoTpUtils::HexStrToDec(listViewMappings.GetItemText(index, 8)) });
	}
	// Clear listview of mappings
	listViewMappings.DeleteAllItems();
	
	// Loop through all configured mappings and add them to UI.
	for (UINT i = 0; i < m_mappings.size(); i++)
	{
		AddData(m_mappings[i]);
		// Checks if the current Mapping was the selected one and if so sets back the selection to it
		UINT32 loop_uniqueID = CPCanIsoTpUtils::GetUniqueID({ (int)m_mappings[i]->m_canId, (int)m_mappings[i]->m_canIdResponse, m_mappings[i]->m_targetType, m_mappings[i]->m_canIdType,
			m_mappings[i]->m_sourceAddr, m_mappings[i]->m_targetAddr, m_mappings[i]->m_msgType, m_mappings[i]->m_formatType, m_mappings[i]->m_remoteAddr });
		if (loop_uniqueID == uniqueID) listViewMappings.SetItemState(i, LVIS_SELECTED, LVIS_SELECTED);
	}
	((CPcanIsoTpExampleDlg*)this->GetParent())->m_dlgMessages->FillComboMappings();
}

/// <summary>
/// Function called to reste all mappings.
/// </summary>
void CPCanIsoTpExampleDlgMappings::ResetMappingList()
{
	if (!m_mappings.empty())
	{
		for (UINT32 i = 0; i < m_mappings.size(); i++)
		{
			if (m_mappings[i] != NULL)
			{
				delete m_mappings[i];
				m_mappings[i] = NULL;
			}
		}
		m_mappings.clear();
		listViewMappings.RemoveAllGroups();
	}
}

/// <summary>
/// Add rows to the CListCtrl
/// </summary>
void CPCanIsoTpExampleDlgMappings::AddData(MappingStatus* p_mapping)
{
	int nItem = listViewMappings.GetItemCount();
	nItem = listViewMappings.InsertItem(nItem, p_mapping->CanId());
	listViewMappings.SetItemText(nItem, 1, p_mapping->CanIdResponse());
	listViewMappings.SetItemText(nItem, 2, p_mapping->TargetType());
	listViewMappings.SetItemText(nItem, 3, p_mapping->CanIdType());
	listViewMappings.SetItemText(nItem, 4, p_mapping->SourceAddress());
	listViewMappings.SetItemText(nItem, 5, p_mapping->TargetAddress());
	listViewMappings.SetItemText(nItem, 6, p_mapping->MsgType());
	listViewMappings.SetItemText(nItem, 7, p_mapping->FormatType());
	listViewMappings.SetItemText(nItem, 8, p_mapping->RemoteAddress());
	listViewMappings.EnsureVisible(nItem, FALSE);
}


/// <summary>
/// Event handler called when the Dialog is destroyed.
/// </summary>
void CPCanIsoTpExampleDlgMappings::PostNcDestroy()
{
	for (UINT i = 0; i < m_mappings.size(); i++)
	{
		if (m_mappings[i] != NULL)
		{
			delete m_mappings[i];
			m_mappings[i] = NULL;
		}
	}
	// Add code before PostNcDestroy();
	CDialogEx::PostNcDestroy();
	delete this;
}


/// <summary>
/// Event handler called when Button Example is clicked.
/// </summary>
void CPCanIsoTpExampleDlgMappings::OnBnClickedButtonExample()
{
	byte clientAddr = 0xF1;    // Tester Client address
	byte ecuAddr = 0x13;       // ECU address
	byte funcAddr = 0x20;      // Functional address
	UINT32 canIdCli2Ecu = 0xA1;  // CAN ID used to communicate from Client to ECU
	UINT32 canIdEcu2Cli = 0xA2;  // CAN ID used to communicate from ECU to Client
	UINT32 canIdCliFunc = 0xA3;  // CAN ID used to communicate from Client to any ECUs

	// The sample defines 11 bits CAN ID, normal format addressing mappings 
	//  (diagnostic message will be mandatory since normal format addressing is used)

	// Defines a p_mapping to allow communication from client to ECU (a.k.a request).
	MappingsAdd(new MappingStatus(canIdCli2Ecu, canIdEcu2Cli,
		PCANTP_ID_CAN_11BIT,
		PCANTP_FORMAT_NORMAL,
		PCANTP_MESSAGE_DIAGNOSTIC,
		PCANTP_ADDRESSING_PHYSICAL,
		clientAddr, ecuAddr, 0x00));

	// Defines a p_mapping to allow communication from ECU to client (a.k.a response).
	MappingsAdd(new MappingStatus(canIdEcu2Cli, canIdCli2Ecu,
		PCANTP_ID_CAN_11BIT,
		PCANTP_FORMAT_NORMAL,
		PCANTP_MESSAGE_DIAGNOSTIC,
		PCANTP_ADDRESSING_PHYSICAL,
		ecuAddr, clientAddr, 0x00));

	// define p_mapping to allow communication from client to any ECUs (a.k.a functional request).
	MappingsAdd(new MappingStatus(canIdCliFunc, CAN_ID_NO_MAPPING,
		PCANTP_ID_CAN_11BIT,
		PCANTP_FORMAT_NORMAL,
		PCANTP_MESSAGE_DIAGNOSTIC,
		PCANTP_ADDRESSING_FUNCTIONAL,
		clientAddr, funcAddr, 0x00));

	// Refreshes all UIs dealing with mappings.
	MappingsChanged();
}

/// <summary>
/// Sets a new p_mapping to the ISO-TP API.domodal
/// </summary>
/// <param name="p_mapping"></param>
void CPCanIsoTpExampleDlgMappings::MappingsAdd(MappingStatus *p_mapping)
{
	TPCANTPStatus sts;

	// Adds the p_mapping inside the API
	sts = CANTP_AddMapping(*m_pctpHandle, p_mapping->m_canId, p_mapping->m_canIdResponse,
							p_mapping->m_canIdType, p_mapping->m_formatType, p_mapping->m_msgType,
							p_mapping->m_sourceAddr, p_mapping->m_targetAddr, p_mapping->m_targetType, p_mapping->m_remoteAddr);
	CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, p_mapping);
	if (sts == PCANTP_ERROR_OK)
	{
		// Adds the p_mapping to the internal list of configured mappings.
		m_mappings.push_back(p_mapping);
	}
	else
	{
		// If it is not added to the list of mappings it will never deleted
		// Free memory here
		if (p_mapping != NULL)
		{
			delete p_mapping;
			p_mapping = NULL;
		}
	}
}

/// <summary>
/// Event handler called when button "Delete Mapping" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgMappings::OnBnClickedButtonRemove()
{
	TPCANTPStatus sts;

	// Asserts the selection is valid
	// index of the selected p_mapping in listViewMappings
	POSITION index_value = listViewMappings.GetFirstSelectedItemPosition();
	int index = reinterpret_cast<int>(index_value) - 1;
	if (index < 0)
		return; // No item is selected
		
	// Prevent deletion of "automatic p_mapping" 
	//  (those mappings do not exist in the ISO-TP API, they are displayed
	//  as a tutorial purpose)
	if (index < 5) // There are 5 automatics mappings
		return;

	// Prevent a deletion of a p_mapping that is not in the list
	if ((int)m_mappings.size() < index) return;

	// Removes the p_mapping from the API (via the CAN ID that defines it uniquely)
	sts = CANTP_RemoveMapping(*m_pctpHandle, m_mappings[index]->m_canId);
	CPCanIsoTpUtils::checkCanTpStatus(*m_pctpHandle, sts, { (int)m_mappings[index]->m_canId });
	if (sts == PCANTP_ERROR_OK)
	{
		// Removes the p_mapping from the internal list of mappings
		if (m_mappings[index] != NULL)
		{
			delete m_mappings[index];
			m_mappings[index] = NULL;
		}
		m_mappings.erase(m_mappings.begin() + index);
	}
	// updates all UI components according to the new settings
	MappingsChanged();
	// Select next p_mapping 
	listViewMappings.SetItemState(-1, ~LVIS_SELECTED, LVIS_SELECTED);
	listViewMappings.SetItemState(index, LVIS_SELECTED, LVIS_SELECTED);
	listViewMappings.SetSelectionMark(index);
}


/// <summary>
/// Event handler called when Button "Add Mapping" is clicked.
/// </summary>
void CPCanIsoTpExampleDlgMappings::OnBnClickedButtonAdd()
{
	INT_PTR nRet = -1;
	CPCanIsoTpExampleDlgAddNewMappings dlgModal;

	nRet = dlgModal.DoModal(); // Creates a modal dialog
	
	// If the new p_mapping dialog return IDOK a new p_mapping is added 
	if (nRet == IDOK) {
		MappingsAdd(new MappingStatus(dlgModal.m_canId, dlgModal.m_canIdResponse, dlgModal.m_canIdType, dlgModal.m_formatType,
			dlgModal.m_msgType, dlgModal.m_targetType, dlgModal.m_sourceAddr, dlgModal.m_targetAddr, dlgModal.m_remoteAddr));
		// updates all UI components according to the new settings
		MappingsChanged();
	}
}


/// <summary>
/// Event handler called when Button "Save Mappings" is clicked.
/// Save all mappings created in a CSV file
/// </summary>
void CPCanIsoTpExampleDlgMappings::OnBnClickedButtonSaveMappings()
{
	try
	{
		CString CSVHeader = L"CAN_ID;CAN_ID response;Target Type;ID Type;SA;TA;MsgType;Format;RA";
		CString newLine = L"";
		CStdioFile mappingFileWriter;
		wchar_t currentDir[1024] = { '\0' };
		GetCurrentDirectory(MAX_PATH, currentDir);
		CString fileName = currentDir;
		fileName += L"\\Mappings.csv";

		if (mappingFileWriter.Open(fileName, CFile::modeCreate | CFile::modeWrite))
		{
			mappingFileWriter.WriteString(CSVHeader);
			for (UINT32 i = 5; i < m_mappings.size(); i++) // Skip 5 firsts defaults mappings
			{
				CString intToString = L"";
				newLine.Format(L"\n%d;%d;%d;%d;%d;%d;%d;%d;%d", m_mappings[i]->m_canId, m_mappings[i]->m_canIdResponse, m_mappings[i]->m_targetType,
					m_mappings[i]->m_canIdType, m_mappings[i]->m_sourceAddr, m_mappings[i]->m_targetAddr,
					m_mappings[i]->m_msgType, m_mappings[i]->m_formatType, m_mappings[i]->m_remoteAddr);
				mappingFileWriter.WriteString(newLine);
			}
			mappingFileWriter.Flush();
		}

	}
	catch (...) {};
}


/// <summary>
/// Event handler called when Button "Load Mappings" is clicked.
/// Load all mappings of the CSV file "Mappings.csv"
/// </summary>
void CPCanIsoTpExampleDlgMappings::OnBnClickedButtonLoadMappings()
{
	CFile mappingFileWriter;
	wchar_t currentDir[1024] = { '\0' };
	GetCurrentDirectory(MAX_PATH, currentDir);
	CString fileName = currentDir;
	fileName += L"\\Mappings.csv";
	CString newLine;
	try
	{
		if (PathFileExists(fileName) == TRUE)
		{
			// Open the file to read from.
			bool skipFirstLine = true; // First line is CSV header
			CStdioFile file(fileName, CFile::modeRead);
			while (file.ReadString(newLine))
			{
				if (skipFirstLine == true)
				{
					skipFirstLine = false;
					continue;
				}
				CStringArray allValues;
				int i = 0;
				for (CString sItem = newLine.Tokenize(L";", i); i >= 0; sItem = newLine.Tokenize(L";", i))
				{
					allValues.Add(sItem);
				}
				if (allValues.GetCount() == 9) // Mapping must have 9 elements to be valid
				{
					//            0      1                  2           3    4  5   6       7     8
					//newLine = "CAN_ID;CAN_ID response;Target Type;ID Type;SA;TA;MsgType;Format;RA" + Environment.NewLine;
					//p_mapping = new MappingStatus(0, 1, 3, 7, 6, 2, 4, 5, 8) : order of informations vs mappingsstatus constructor
					MappingsAdd(new MappingStatus(_tstoi(allValues[0]),
												_tstoi(allValues[1]),
												(TPCANTPIdType)_tstoi(allValues[3]),
												(TPCANTPFormatType)_tstoi(allValues[7]),
												(TPCANTPMessageType)_tstoi(allValues[6]),
												(TPCANTPAddressingType)_tstoi(allValues[2]),
												_tstoi(allValues[4]),
												_tstoi(allValues[5]),
												_tstoi(allValues[8])));
					MappingsChanged();
				}
			}
		}
	}
	catch (...) {};
}


/// <summary>
/// Event handler called on Init Dialog.
/// </summary>
BOOL CPCanIsoTpExampleDlgMappings::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	listViewMappings.InsertColumn(0, L"CAN ID");
	listViewMappings.SetColumnWidth(0, 80);
	listViewMappings.InsertColumn(1, L"CAN ID Response");
	listViewMappings.SetColumnWidth(1, 120);
	listViewMappings.InsertColumn(2, L"Target Type");
	listViewMappings.SetColumnWidth(2, 120);
	listViewMappings.InsertColumn(3, L"ID Type");
	listViewMappings.SetColumnWidth(3, 80);
	listViewMappings.InsertColumn(4, L"SA");
	listViewMappings.SetColumnWidth(4, 60);
	listViewMappings.InsertColumn(5, L"TA");
	listViewMappings.SetColumnWidth(5, 60);
	listViewMappings.InsertColumn(6, L"Msg Type");
	listViewMappings.SetColumnWidth(6, 80);
	listViewMappings.InsertColumn(7, L"Format");
	listViewMappings.SetColumnWidth(7, 90);
	listViewMappings.InsertColumn(8, L"RA");
	listViewMappings.SetColumnWidth(8, 60);
	listViewMappings.SendMessage(LVM_SETEXTENDEDLISTVIEWSTYLE, 0,
		LVS_EX_FULLROWSELECT);

	return TRUE;  // return TRUE unless you set the focus to a control
				  // EXCEPTION: OCX Property Pages should return FALSE
}

/// <summary>
/// Catch message from KEY DELETE and delete selected record
/// </summary>
BOOL CPCanIsoTpExampleDlgMappings::PreTranslateMessage(MSG* pMsg)
{
	if (pMsg->message == WM_KEYDOWN)
	{
			switch (pMsg->wParam)
			{
			case VK_DELETE: // Key "Delete"
				OnBnClickedButtonRemove();
				::TranslateMessage(pMsg);
				::DispatchMessage(pMsg);
				break;
			}
		}
	return CDialogEx::PreTranslateMessage(pMsg);
}


/// <summary>
/// Event handler called when a p_mapping is selected.
/// </summary>
void CPCanIsoTpExampleDlgMappings::OnLvnItemchangedListMappings(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	POSITION index_value = listViewMappings.GetFirstSelectedItemPosition();
	int index = reinterpret_cast<int>(index_value);
	// If it is a default p_mapping remove is desabled
	if (index <= 5)
		buttonMappingDel.EnableWindow(false);
	else
		buttonMappingDel.EnableWindow(true);
	*pResult = 0;
}


/// <summary>
/// Event handler called when a p_mapping is selected.
/// </summary>
void CPCanIsoTpExampleDlgMappings::OnLvnInsertitemListMappings(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMLISTVIEW pNMLV = reinterpret_cast<LPNMLISTVIEW>(pNMHDR);
	POSITION index_value = listViewMappings.GetFirstSelectedItemPosition();
	int index = reinterpret_cast<int>(index_value);
	if (index <= 5)
		buttonMappingDel.EnableWindow(false);
	else
		buttonMappingDel.EnableWindow(true);
	*pResult = 0;
}
